﻿var requiredFields = $H({});

$(document).ready(function() {
	// 数据选择以及高亮
	// 用于菜单和列表
	$('.data-list tr input[type=checkbox]').click(function() {
		var result = $('input[type=checkbox]', this);
		$(this.parentNode.parentNode).toggleClass('tr_selected');
	});
	$('.data-list tr, .menu tr').mouseover(function() {
		if (this.className.indexOf('tr_selected') > -1) return;
		this.className = 'tr_over';
	}).mouseout(function() {
		if (this.className.indexOf('tr_selected') > -1) return;
		this.className = 'tr_out';
	});
	// 表单焦点高亮
	$('.txt').focus(function() {
		$(this).removeClass('input_blur').addClass('input_focus');
	}).blur(function() {
		$(this).removeClass('input_focus').addClass('input_blur');
	});
	// 显示帮助提示
	$('.help').click(function() {
		$('.helpTxt', this.parentNode).toggle();
	});
	// 全选和取消全选
	$('#checkAll').click(function() {
		check_all();
		if (!this.checked) anti_check();
	});
	// 颜色选择器
	$('.color-value').each(function() {
		// 初始化颜色
		var color = $(this).val();
		var target = $('input[name='+$(this).attr('name').replace('Color', '')+']');
		target.css({color: color});
	});
	$('.color-seleter').click(function() {
		// 设置颜色
		var rel = $(this).attr('rel');
		var target = $('input[name='+rel+']');
		var targetInput = $('input[name='+rel.replace('Color', '')+']');
		var position = targetInput.position();
		if (!$E('color-seleter')) {
			$("body").append('\
				<div id="color-seleter" style="display:none;">\
					<ul>\
						<li><a href="#"><img src="_public_/Style/default/images/blank.gif" style="background:#ffffff;" />不选择</a></li>\
						<li><a href="#"><img src="_public_/Style/default/images/blank.gif" style="background:#cc0000;" />深红色</a></li>\
						<li><a href="#"><img src="_public_/Style/default/images/blank.gif" style="background:#1562e9;" />深蓝色</a></li>\
						<li><a href="#"><img src="_public_/Style/default/images/blank.gif" style="background:#fb5903;" />橙黄色</a></li>\
						<li><a href="#"><img src="_public_/Style/default/images/blank.gif" style="background:#a60af4;" />暗紫色</a></li>\
						<li><a href="#"><img src="_public_/Style/default/images/blank.gif" style="background:#000000;" />纯黑色</a></li>\
					</ul>\
				</div>\
			');
		}
		var selecter = $('#color-seleter');
		$('li a', selecter).click(function() {
			// 选择颜色
			var color = $('img', this).css('background');
			if (color == '#ffffff') color = '';
			target.val(color);
			targetInput.css({color: color});				
			$(document).unbind();
			selecter.hide();
			return false;
		});
		selecter.css({left: position.left + targetInput.width() - 78, top: position.top + targetInput.height() + 4}).show();
		$(document).click(function() {
			selecter.hide();
		});
		return false;
	});
});

// 进入编辑状态
function renameFocus(obj) {
	var fileName = obj.innerHTML;
	System.Cache.rename = fileName;
	$(obj).replaceWith('<input value="'+fileName+'" type="text" class="txt" onblur="renameBlur(this);" onkeyup="renameAutoWidth(this);" onKeyDown="if(window.event.keyCode==13)return false;" id="reameInput" style="width:'+(8*fileName.length)+'px;" />');
	$('#reameInput').focus();
}

// 提交修改
function renameBlur(obj) {
	var path = $('#path').val().replace('/', '');
	var source = path + System.Cache.rename;
	var target = path + $(obj).val();
	if (source != target) $.get('?channel=Base&action=renameFile&source='+source+'&target='+target);
	$(obj).replaceWith('<span onclick="renameFocus(this);">'+$(obj).val()+'</span>');
}

// 表单长度自适应
function renameAutoWidth(obj) {
	$(obj).width(8*$(obj).val().length);
}

// 全选
function check_all(form, field) {
	form = form || 'form';
	field = field || 'id';
	$('#'+form+' input[name='+field+']').attr('checked', 'checked').parent().parent().addClass('tr_selected');
}

// 反选
function anti_check(form, field) {
	form = form || 'form';
	field = field || 'id';
	$('#'+form+' input[name='+field+']').each(function() {
		this.checked = !this.checked;
		this.parentNode.parentNode.className = this.checked ? 'tr_selected' : 'tr_out';
	});
}

// 复制
function copy(str, template) {
	str = str.replace(/&lt;/img, '<').replace(/&gt;/img, '>');
	if (template) {
		template = template.replace(/\[/g, '{').replace(/\]/g, '}');
		str = template.format(str);
	}
	window.clipboardData.setData("Text", str);
	alert('成功将如下内容复制到剪贴板：\n\n'+str.substring(0, 60)+(str.length > 60 ? '...' : ''));
}

// 转到
function goto(url) {
	location.href = url;
	return false;
}

// 提交
function postTo(url, form) {
	form = $E(form || 'form');
	form.action = url;
	var params = url.toQueryParams();
	for (var key in params) {
		if (form[key]) form[key].value = params[key];
	}
	form.submit();
}

// 转到指定页（用于分页）
function jumpTo(pn) {
	if (!/^\d+$/.test(pn)) return alert('参数错误！');
	var url = System.ThisUrl;
	var aim = url.indexOf('&pn=') > -1 ? url.replace(/pn=\d+/, 'pn=' + pn) : url + '&pn=' + pn;
	postTo(aim);
}

// 初始化表单
function initForm(data, readOnly, form) {
	form = $E(form || 'form');
	for (var key in data) {
		if (form[key]) {
			var value = data[key];
			if (value !== null) {
				if (typeof(value) == 'string') {
					var dateType = $(form[key]).attr("dateType");
					if (dateType) {
						if (dateType == 'date') {
							value = value.split(' ')[0];
						}
					}
					value = [value];
				}
				if (form[key][0]) {
					value = $C(value).split(',');
					if ($(form[key]).attr('type') == 'checkbox') {
						if (![''].include(value)) value.push('');
					}
				}
				$(form[key]).val(value);
			}
		}
	}
	if (readOnly) {
		for (var i = 0; i < readOnly.length; i++) {
			if (form[key]) $(form[readOnly[i]]).attr('disabled', true);
		}
	}
}

// 表单验证
function checkForm(form) {
	form = $E(form || 'form');
	var formData = $(form).serialize().toQueryParams();
	if (!_checkRequired(form, formData, requiredFields)) return false;
	form.submit();
	$E('submit').onclick = function() {
		alert('请不要重复提交');
	};
}

// 验证表单必填项
function _checkRequired(form, formData, requiredFields) {
	var err = [];
	for (var key in formData) {
		if ($(form[key]).attr('type') == 'checkbox') {
			if (typeof(formData[key]) == 'string') formData[key] = [formData[key]];
			if (formData[key].length > 1) {
				$(form[key]).val(formData[key].without(''));
			}
		}
	}
	requiredFields.each(function(field) {
		// 必填项
		if (!formData[field.key]) {
			err.push(field.value);
		}
	});
	if (err.length > 0) {
		showPostErr(err.join('、')+'为必填项');
		return false;
	}
	return true;
}

// 显示表单提交错误信息
function showPostErr(msg) {
	$('#failed').html(msg).fadeIn('slow');
	setTimeout(function() {
		$('#failed').html(msg).fadeOut('slow');
	}, 3000);
}

// 批量删除
function batchDelete(aim, form) {
	if (!_checkBatchSelect(form, 'del')) return false;
	postTo(aim, form);
}

// 批量生成
function batchCreate(aim, form) {
	if (!_checkBatchSelect(form)) return false;
	postTo(aim, form);
}

// 检查选择状况
function _checkBatchSelect(form, type) {
	form = $E(form || 'form');
	type = type || '';
	var formData = $(form).serialize();
	if(formData == '') {
		alert('您没有选择任何项目！');
		return false;
	}
	if (type == 'del') return confirm('确定要删除？');
	return true;
}

// 上传对话框
function showUploadDialog(s_Type, s_Link, s_Thumbnail) {
	var arr = showModalDialog("../public/TextEditor/FckEditor/editor/dialog/fck_upload.htm?type="+s_Type+"&link="+s_Link+"&thumbnail="+s_Thumbnail, window, "dialogWidth:340px;dialogHeight:168px;help:no;scroll:no;status:no;center:yes;resizable:no;");
}